/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="__get-jmsdest")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.GET, path="__get-jmsdest", description="Get JMS Destinations", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.GET, path="__get-jmsdest", description="Get JMS Destinations", params={@RestParam(name="target", value="$parent")})})
public class GetJmsPhysicalDestinationCommand
extends JMSDestination
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetJmsPhysicalDestinationCommand.class);
    @Param(name="desttype", shortName="t", optional=false)
    String destType;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        logger.entering(this.getClass().getName(), "__getJmsPhysicalDestination", new Object[]{this.destName, this.destType});
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
            Map<String, Object> entity = this.getJMSDestination();
            Properties ep = new Properties();
            ep.put("entity", entity);
            report.setExtraProperties(ep);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getJMSDestination() throws Exception {
        logger.log(Level.FINE, "__getJmsPhysicalDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
        HashMap<String, Object> destAttrs = new HashMap<String, Object>();
        try {
            MBeanAttributeInfo[] attribs;
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            if (this.destType.equalsIgnoreCase("topic")) {
                this.destType = "t";
            } else if (this.destType.equalsIgnoreCase("queue")) {
                this.destType = "q";
            }
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=Destination,subtype=Config,desttype=" + this.destType + ",name=\"" + this.destName + "\"");
            for (MBeanAttributeInfo attrib : attribs = mbsc.getMBeanInfo(on).getAttributes()) {
                destAttrs.put(attrib.getName(), mbsc.getAttribute(on, attrib.getName()));
            }
            HashMap<String, Object> hashMap = destAttrs;
            return hashMap;
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_getting_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return destAttrs;
    }
}

